#!/bin/bash
################################################## #########
# Bash script to find which OS
################################################## #########
TEMP_PATH=$0

OS=`uname`

if [ "$OS" = "Linux" ];then
	echo "Your system:\n           ^_^  Linux ^_^\n"
	if [ $# = "2" ] && ([ $1 = "A" ] || [ $1 = "a" ]);then
		if test $(id -ur) != 0; then
			echo "\n     You should operate it  As   root OR sudo   \n"
			exit -1
		fi
		cp ../libcastle.so.1.0.0 /usr/lib/
		cp nssThunderbird /usr/lib/thunderbird
		export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:/usr/lib/thunderbird"
		/usr/lib/thunderbird/nssThunderbird $1 $2 /usr/lib/libcastle.so.1.0.0
	elif [ $# = "2" ] && ([ $1 = "D" ] || [ $1 = "d" ]);then
		export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:/usr/lib/thunderbird"
		/usr/lib/thunderbird/nssThunderbird $1 $2
	else
		echo "Error:\nAdd(A) or Delete(D) Module : \nsh register_Thunderbird.sh  A moduleName  \nsh register_Thunderbird.sh  D moduleName \n\n"
	fi

elif [ "$OS" = "Darwin" ];then 
#	cp ../libcastle.1.0.0.dylib /usr/lib/
#	cp nssThunderbird /Applications/Thunderbird.app/Contents/MacOS/
	echo "Your system:\n            ^_^ MacOs ^_^\n"
	if [ $# = "2" ] && ([ $1 = "A" ] || [ $1 = "a" ]);then
#		if test $(id -ur) != 0; then
#			echo "\n     You should operate it  As   root OR sudo   \n"
#			exit -1
#		fi
		/Applications/Thunderbird.app/Contents/MacOS/nssThunderbird $1 $2 /usr/lib/libcastle.1.0.0.dylib
	elif [ $# = "2" ] && ([ $1 = "D" ] || [ $1 = "d" ]);then
		/Applications/Thunderbird.app/Contents/MacOS/nssThunderbird $1 $2
	else
		echo "Error:\nAdd(A) or Delete(D) Module : \nsh register_Thunderbird.sh  A moduleName  \nsh register_Thunderbird.sh  D moduleName \n\n"
	fi
	
else
	echo "     ^_^-- Don't support your system --^^    \n"
fi

